require( "scripts/style.lua" );
require( "scripts/leveldescriptions.lua" );


if (is_endless == true) then
	myInstr_Descr = "intro_level_endless";
else 
	myInstr_Descr = "intro_level_"..gLevel;
end;

DebugOut(myInstr_Descr);

	
LevelInfoText = {
  standardFont,
  19,
  BlackColor
};

TextStyle =
{
	parent 	= DialogBodyText,
	font   	= LevelInfoText,
	x 		= kCenter+16,
	y 		= kCenter+68, 
	w 		= 400,
	h 		= 270, 
	flags 	= kVAlignCenter + kHAlignCenter,
};

if (is_endless == true) then
	textrelated_image = "instructions/lvlendless";
else 
	textrelated_image = "instructions/lvl"..gLevel;
end;


FontButton = {
    standardFont,
    16,
    Color(0,0,0,255)
};

-----------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------
MakeDialog
{
	name="LevelIntroduction",
	IntroDialog
	{
		fit 	= true,
		x		= kCenter,
		y		= kCenter,
		w		= kMax,
		h		= kMax,
		
		fadeSpeed	= 1.75;
		
		Bitmap
		{
			name  	= "custom_bg_image",
			image 	= "backgrounds/intro_dialog",
			x		= kCenter,
			y		= kCenter,	
			alpha 	= 0.99,
		},	
		
		Bitmap
		{
			name  	= "textrelated_image",
			image 	= textrelated_image,
			x		= kCenter,
			y		= kCenter - 120,	
			alpha 	= 0.99,
		},	
						
		SetStyle(TextStyle),
		Text
		{
			font	= { standardFont, 20, BlackColor },
			label	= myInstr_Descr,
			w 		= 380,
			y 		= 290-15,
		},
		
		SetStyle(ButtonStyle),
		Button
		{
			label	= "done",
			name	= "btndone",
			x		= kCenter,
			y		= kMax-58,
			font	= FontButton,
			graphics = 
					{ 
						"buttons/btn_pause_norm",
						"buttons/btn_pause_down",
						"buttons/btn_pause_over" 
					},
			command	= function()
						FadeOutAndClose();
						GameResumeFromDialog();
						--CloseWindow(nil);
					  end;
		},
	},
}
-----------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------
GameInPauseDialog(false, false);